elexname = CElpasElex;
elexfilename = "..\elpas\ElpasElex";

include = {*
#include "stdafx.h"
#include <string.h>
*};

COLON					{:;:};
OR						{:#|#|:};
EQUAL					{:=:};
DERIVE					{:#->:};
ELEXNAME				{:elexname:};
ELEXFILENAME			{:elexfilename:};
ELPASNAME				{:elpasname:};
ELPASFILENAME			{:elpasfilename:};
INCLUDE					{:include:};
DEFINE					{:define:};
ERROR					{:error:};
NONTERM					{:<[a-zA-Z][a-zA-z0-9#_$]*>:}
{*
	int iPathLen = strlen(GetText()) - 2;
	char* pPathName = new char[iPathLen + 1];
	strncpy(pPathName, GetText() + 1, iPathLen);
	pPathName[iPathLen] = 0;

	SetText(pPathName);
	delete[] pPathName;
*};

TERM					{:[a-zA-Z][a-zA-z0-9#_$]*:};

FILE					{:#"[#|#*#?#"<>/#:" "\n\t]~([#\/]|[#|#*#?#"<>/#:\n\t]~)*[#|#*#?#"<>/#:" "\n\t]~#":}
{*
	int iPathLen = strlen(GetText()) - 2;
	char* pPathName = new char[iPathLen + 1];
	strncpy(pPathName, GetText() + 1, iPathLen);
	pPathName[iPathLen] = 0;

	SetText(pPathName);
	delete[] pPathName;
*};

SCRIPT					{:#{#*(#*#})~*#*#}:}
{*
	const char* pTemp = GetText();
	int iLen = strlen(pTemp);
	for (int i = 0; i < iLen; i++)
		if (pTemp[i] == '\n') NEWLINE;

	char* pNew = new char[iLen - 4 + 1];
	strncpy(pNew, pTemp + 2, iLen - 4);
	pNew[iLen - 4] = 0;

	SetText(pNew);
	delete[] pNew;
*};

WHITESPACE	(ignore)	{:[" "\t]+:};

REMARKLINE	(ignore)	{://[\r\n]~*\r?\n:}
{*
	NEWLINE;
*};

REMARK		(ignore)	{:/#*/*((/~*)|([/#*]~/*))*#*/:}
{*
	const char* pTemp = GetText();
	for (int i = 0; i < strlen(pTemp); i++)
		if (pTemp[i] == '\n') NEWLINE;
*};

NEWLINE		(ignore)	{:\r?\n:}
{*
	NEWLINE;
*};
